/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import panther.util.general.OpsOut;

public class CachedResultSet
implements ResultSet,
Serializable {
    public static final long serialVersionUID = 0L;
    List rows = new ArrayList();
    private int currentRow = -1;
    private static final String notImplemented = "This method is not implemented in the CachedResultSet";
    String[] columnNames;

    public int getRowCount() {
        return this.rows.size();
    }

    public CachedResultSet(ResultSet resultSet) {
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            this.columnNames = new String[n2];
            for (n = 0; n < n2; ++n) {
                this.columnNames[n] = resultSetMetaData.getColumnName(n + 1);
            }
            while (resultSet.next()) {
                Object[] objectArray = new Object[n2];
                for (n = 0; n < n2; ++n) {
                    objectArray[n] = resultSet.getObject(n + 1);
                }
                this.rows.add(objectArray);
            }
        }
        catch (SQLException sQLException) {
            OpsOut.trace(sQLException);
            throw new RuntimeException(sQLException.getMessage());
        }
    }

    public CachedResultSet(CachedResultSet cachedResultSet, boolean bl) {
        this.columnNames = new String[cachedResultSet.columnNames.length];
        for (int i = 0; i < cachedResultSet.columnNames.length; ++i) {
            this.columnNames[i] = cachedResultSet.columnNames[i];
        }
        this.rows.addAll(cachedResultSet.rows);
    }

    public boolean next() throws SQLException {
        return ++this.currentRow < this.rows.size();
    }

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public String getString(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return false;
        }
        return ((Number)object).intValue() != 0;
    }

    public byte getByte(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return 0;
        }
        return ((Number)object).byteValue();
    }

    public short getShort(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return 0;
        }
        return ((Number)object).shortValue();
    }

    public int getInt(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return 0;
        }
        return ((Number)object).intValue();
    }

    public long getLong(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return 0L;
        }
        return ((Number)object).longValue();
    }

    public float getFloat(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return 0.0f;
        }
        return ((Number)object).floatValue();
    }

    public double getDouble(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return 0.0;
        }
        return ((Number)object).doubleValue();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)((Object[])this.rows.get(this.currentRow))[n - 1];
        bigDecimal.setScale(n2);
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        return (byte[])((Object[])this.rows.get(this.currentRow))[n - 1];
    }

    public Date getDate(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return new Date(0L);
        }
        return new Date(((java.util.Date)object).getTime());
    }

    public Time getTime(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return new Time(0L);
        }
        return (Time)object;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = ((Object[])this.rows.get(this.currentRow))[n - 1];
        if (object == null) {
            return new Timestamp(0L);
        }
        return (Timestamp)object;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Object getObject(int n) throws SQLException {
        return ((Object[])this.rows.get(this.currentRow))[n - 1];
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (!string.equalsIgnoreCase(this.columnNames[i])) continue;
            return i + 1;
        }
        throw new IndexOutOfBoundsException(string + " is not a valid column name for the resultset.");
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)((Object[])this.rows.get(this.currentRow))[n - 1];
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.currentRow == -1;
    }

    public boolean isAfterLast() throws SQLException {
        return this.currentRow >= this.rows.size();
    }

    public boolean isFirst() throws SQLException {
        return this.currentRow == 0;
    }

    public boolean isLast() throws SQLException {
        return this.currentRow == this.rows.size() - 1;
    }

    public void beforeFirst() throws SQLException {
        this.currentRow = -1;
    }

    public void afterLast() throws SQLException {
        this.currentRow = this.rows.size();
    }

    public boolean first() throws SQLException {
        this.currentRow = 0;
        return this.currentRow >= 0 && this.currentRow < this.rows.size();
    }

    public boolean last() throws SQLException {
        this.currentRow = this.rows.size() - 1;
        return this.currentRow >= 0 && this.currentRow < this.rows.size();
    }

    public int getRow() throws SQLException {
        return this.currentRow + 1;
    }

    public boolean absolute(int n) throws SQLException {
        this.currentRow = n - 1;
        return this.currentRow >= 0 && this.currentRow < this.rows.size();
    }

    public boolean relative(int n) throws SQLException {
        this.currentRow += n;
        return this.currentRow >= 0 && this.currentRow < this.rows.size();
    }

    public boolean previous() throws SQLException {
        --this.currentRow;
        return this.currentRow >= 0 && this.currentRow < this.rows.size();
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void setFetchSize(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int getType() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int getConcurrency() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateNull(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateNull(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Ref getRef(int n) throws SQLException {
        return (Ref)((Object[])this.rows.get(this.currentRow))[n - 1];
    }

    public Blob getBlob(int n) throws SQLException {
        return (Blob)((Object[])this.rows.get(this.currentRow))[n - 1];
    }

    public Clob getClob(int n) throws SQLException {
        return (Clob)((Object[])this.rows.get(this.currentRow))[n - 1];
    }

    public Array getArray(int n) throws SQLException {
        return (Array)((Object[])this.rows.get(this.currentRow))[n - 1];
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public URL getURL(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }
}

